#!/usr/bin/perl
# Copyright (c) 2009 Landry Breuil <breuil@craig.fr>
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
# WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
# ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
# ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

my @fics = glob("*CODE_DEPARTEMENT*");
foreach my $fic (@fics) {
	print STDOUT "Lecture de $fic\n";
	open (INPUT,$fic) || die "error opening $fic : $!";
	my $cur = 0;
	my $insee = 0;
	my $output;
	while (<INPUT>) {
		my $line = $_;
		if (/^(\d\d)0;?(\d\d\d).*/) {
			$insee = "$1$2";
			if ($insee != $cur) {
				print STDOUT "$fic:nouvelle commune $insee\n";
				# creation du repertoire
				die "le fichier $insee existe et n'est pas un fichier ?" if ((! -d $insee) && -e $insee);
				if (! -d $insee) {
					print STDOUT "creation du repertoire $insee\n";
					mkdir $insee;
				}
				# creation du fichier
				open ($output, ">$insee/".$insee."_".$fic) || die "echec de creation de $insee / $fic : $!";
				select $output;
				$cur = $insee;
			}
			print $line;
		}
	}
}
