#!/usr/bin/perl
# Copyright (c) 2009 Landry Breuil <breuil@craig.fr>
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
# WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
# ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
# ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
use strict;
use warnings;

if ($#ARGV < 1) {
	print "Vous n'avez pas specifie les parametres attendus\n";
	print "Usage: explode_majic_epci.pl rept_sortie insee_1 insee_2 insee_3....\n";
	exit 1;
}
my $rept = shift;
my @comms = @ARGV;
if (! -d $rept) {
	print STDOUT "creation du repertoire de sortie $rept\n";
	mkdir $rept;
}
my $pattern="XX_*";
my @fics = glob($pattern);
if ($#fics < 1) {
	print "Aucun fichiers trouves correspondant au motif $pattern\n";
	print "Les fichiers livres par la DGFIP sont nommes selon le motif XX_YYYY ou XX est le departement et YYYY le type BATI, LLOC, NBAT, PROP, PDLL";
	exit 1;
}
foreach my $fic (@fics) {
	print STDOUT "Lecture de $fic\n";
	open (my $INPUT,'<',$fic) || die "error opening $fic : $!";
	my $output;
	# creation du fichier
	open ($output, ">", "$rept/".$rept."_$fic") || die "echec de creation de $rept / $fic : $!";
	select $output;
	my $ln = 0;
	while (<$INPUT>) {
		my $line = $_;
		if (/^(\d\d)0;?(\d\d\d).*/) {
			my $insee = "$1$2";
			if (grep (/$insee/, @comms)) {
				print $line;
				$ln+=1;
			}
		}
	}
	print STDOUT "pour les ".(1 + $#comms)." communes, $ln lignes extraites dans $rept/".$rept."_$fic\n";
}
